
# Searches and counts feedback loops for all nodes/edges in a network or in a set of networks.
findFBLs <- function(networks, maxLength = 2L) {
  if(is.data.frame(networks)) {
    networks <- loadInbuiltNetwork(networks)
  }
  
  if(isSingleNetwork(networks)) {
    networks <- findFBLs1(networks, maxLength)
    return (networks)
  }
  else if(isListNetworks(networks)) {
    numNetworks <- length(networks)
    for(i in 1:numNetworks) {
      networks[[i]] <- findFBLs1(networks[[i]], maxLength)
    }
    
    return (networks)
  }
  
  return (NULL)
}

findFBLs1 <- function(network, maxLength = 2L) {
  if(is.data.frame(network)) {
    network <- loadInbuiltNetwork(network)
  }
  
  calc <- .jnew("mod.jmut.core.Calc")
  infos <- .jcall(calc, "[I", "findFBLs", as.character(network$name),
                  as.integer(maxLength))
  
  if(is.jnull(infos)) {
    printGeneralError()
    return (network)
  }
  
  fbls <- extractInfos(infos, 3, 3, 3)
  # print(paste("Number of FBL nodes:", fbls[1], sep = "", collapse = ""))
  # print(paste("Number of FBL edges:", fbls[2], sep = "", collapse = ""))
  print(paste("Number of found FBLs:", fbls[9], sep = "", collapse = ""))
  print(paste("Number of found positive FBLs:", fbls[10], sep = "", collapse = ""))
  print(paste("Number of found negative FBLs:", fbls[11], sep = "", collapse = ""))
  network$network[, "NuFBL"] <- unlist(fbls[9])
  network$network[, "NuPosFBL"] <- unlist(fbls[10])
  network$network[, "NuNegFBL"] <- unlist(fbls[11])
  
  network$nodes[, "NuFBL"] <- unlist(fbls[3])
  network$nodes[, "NuPosFBL"] <- unlist(fbls[4])
  network$nodes[, "NuNegFBL"] <- unlist(fbls[5])
  
  network$edges[, "NuFBL"] <- unlist(fbls[6])
  network$edges[, "NuPosFBL"] <- unlist(fbls[7])
  network$edges[, "NuNegFBL"] <- unlist(fbls[8])
  
  return (network)
}

findFFLs <- function(networks) {
  if(is.data.frame(networks)) {
    networks <- loadInbuiltNetwork(networks)
  }
  
  if(isSingleNetwork(networks)) {
    networks <- findFFLs1(networks)
    return (networks)
  }
  else if(isListNetworks(networks)) {
    numNetworks <- length(networks)
    for(i in 1:numNetworks) {
      networks[[i]] <- findFFLs1(networks[[i]])
    }
    
    return (networks)
  }
  
  return (NULL)
}

findFFLs1 <- function(network) {
  if(is.data.frame(network)) {
    network <- loadInbuiltNetwork(network)
  }
  
  calc <- .jnew("mod.jmut.core.Calc")
  infos <- .jcall(calc, "[I", "findFFLs", as.character(network$name),
                  as.integer(2L))
  
  if(is.jnull(infos)) {
    printGeneralError()
    return (network)
  }

# Searches and counts feedforward loops for all nodes/edges in a network or in a set of networks.
ffls <- extractInfos(infos, 4, 4, 3)
# print(paste("Number of FFL nodes:", ffls[1], sep = "", collapse = ""))
# print(paste("Number of FFL edges:", ffls[2], sep = "", collapse = ""))
print(paste("Number of found FFLs:", ffls[11], sep = "", collapse = ""))
print(paste("Number of found coherent FFLs:", ffls[12], sep = "", collapse = ""))
print(paste("Number of found incoherent FFLs:", ffls[13], sep = "", collapse = ""))
network$network[, "NuFFL"] <- unlist(ffls[11])
network$network[, "NuCoFFL"] <- unlist(ffls[12])
network$network[, "NuInCoFFL"] <- unlist(ffls[13])
  
network$nodes[, "NuFFL"] <- unlist(ffls[3])
network$nodes[, "NuFFL_A"] <- unlist(ffls[4])
network$nodes[, "NuFFL_B"] <- unlist(ffls[5])
network$nodes[, "NuFFL_C"] <- unlist(ffls[6])
  
network$edges[, "NuFFL"] <- unlist(ffls[7])
network$edges[, "NuFFL_AB"] <- unlist(ffls[8])
network$edges[, "NuFFL_BC"] <- unlist(ffls[9])
network$edges[, "NuFFL_AC"] <- unlist(ffls[10])
  
return (network)
}

#Calculate centrality measures for all nodes/edges in a network or in a set of networks
calCentrality <- function(networks) {
  if(is.data.frame(networks)) {
    networks <- loadInbuiltNetwork(networks)
  }
  
  if(isSingleNetwork(networks)) {
    networks <- calCentrality1(networks)
    return (networks)
  }
  else if(isListNetworks(networks)) {
    numNetworks <- length(networks)
    for(i in 1:numNetworks) {
      networks[[i]] <- calCentrality1(networks[[i]])
    }
    
    return (networks)
  }
  
  return (NULL)
}

calCentrality1 <- function(network) {
  if(is.data.frame(network)) {
    network <- loadInbuiltNetwork(network)
  }
  
  calc <- .jnew("mod.jmut.core.Calc")
  infos <- .jcall(calc, "[D", "calCentrality", as.character(network$name))
  
  if(is.jnull(infos)) {
    printGeneralError()
    return (network)
  }
  
  cent <- extractInfos(infos, 7, 2)
  # print(paste("Number of Cent nodes:", cent[1], sep = "", collapse = ""))
  # print(paste("Number of Cent edges:", cent[2], sep = "", collapse = ""))
  
  network$nodes[, "Degree"] <- unlist(cent[3])
  network$nodes[, "In_Degree"] <- unlist(cent[4])
  network$nodes[, "Out_Degree"] <- unlist(cent[5])
  network$nodes[, "Closeness"] <- unlist(cent[6])
  network$nodes[, "Betweenness"] <- unlist(cent[7])
  network$nodes[, "Stress"] <- unlist(cent[8])
  network$nodes[, "Eigenvector"] <- unlist(cent[9])
  
  network$edges[, "Degree"] <- unlist(cent[10])
  network$edges[, "Betweenness"] <- unlist(cent[11])
  
  return (network)
}

# search feedback/feed-forward loops
tca_net <- findFBLs(tca_net, maxLength = 10)
tca_net <- findFFLs(tca_net)
write.csv(tca_net$nodes,"node_FBL.csv")
write.csv(tca_net$nodes,"edge_FBL.csv")
write.csv(tca_net$network,"network_structural1.csv")
# calculate node-/edge-based centralities
tca_net <- calCentrality(tca_net)
write.csv(tca_net$nodes,"node_centrality.csv")
write.csv(tca_net$nodes,"edge_centrality.csv")
